//********************************************************************************
//								     Include
//********************************************************************************
#include  "MDSFxx_SFR.h"
#include  "XSFR_GLOBAL.h"
#include  "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//The variables defined by data are placed in the first 128 bytes (0x00~0x7F) address space
//The variables defined by idata are placed in the (0x00~0xFF) address space
//The variable defined by xdata are placed in the external extended RAM  (generally refers to the external 0xF000~0xF1FF space, the specific space size varies with the MCU , and some MCU do not have external RAM)

//The variable defined by data is the fastest, followed by idata, and xdata is slower than the first two
//Variables that are often used are declared with data/idata; variables that are not commonly used are declared with xdata.

#if (IR_Control == 1)
	xdata unsigned int	ir_data[4];
	unsigned char		ir_counter;
	unsigned char		ir_data_shift_counter;
	unsigned int 		ir_read_counter;
	unsigned int 		ir_read_counter_buf;
#endif
//********************************************************************************
//								Interrupt_Init
//********************************************************************************
void Interrupt_Init (void){
	EX0 = dIE0;								//External0_ISR interrupt 	0
	IT0 = dIT0;
	ET0 = dITR0;							//Timer0_ISR interrupt 		1
	EX1 = dIE1;								//External1_ISR interrupt 	2
	IT1 = dIT1;
	ET1 = dITR1;							//Timer1_ISR interrupt 		3
	ESP = dIUR;								//Uart_ISR interrupt 		4
	ET2 = dITR2;							//Timer2_ISR interrupt 		5
	OCPSIE = dIOCP;							//OCP_ISR interrupt 		8
	ADCIE = dIADC;							//ADC_ISR interrupt 		9
	MPWMMINIE = dIPWM_min;					//PmwMin_ISR interrupt 		10
	MPWMMAXIE = dIPWM_MAX;					//PmwMax_ISR interrupt 		11
	IICIE = dIIIC;							//IIC_ISR interrupt 		12
	LVDIIE = dILVF;							//LowVoltage_ISR interrupt 	13
	WDTIE = dIWDF;							//WatchDoag_ISR interrupt 	14
	CAPIE = dICAP;							//Cap_ISR interrupt 		15
	
	IP0 = 0x04;								//Interrupt Priority
	IP1 = 0x14;								//Group 4 > 2 = 0 = 1 = 3 = 5(Solve UR surge problem)
	
	//IP0 = 0x0C;							//Interrupt Priority
	//IP1 = 0x06;							//Group 2 > 3 > 1 > 0
	
	EA = 1;									//Allow interrupt
}
//********************************************************************************
//								     INT0
//********************************************************************************
/*void External0_ISR (void) interrupt 0{
	//P3_3 = 0;
	//EX0 = 0;
}*/
//********************************************************************************
//								     Timer0
//********************************************************************************
void Timer0_ISR (void) interrupt 1{		//1mS
	TH0 = TIMER0_TH;		
	TL0 = TIMER0_TL;
	
	if((FLAG.Current_offset == 0) && (MotorState == M_ADC_INIT)){
		Correction_Current_AD_offset();
	}

	#if (IR_Control == 1)
		if(key_time>0)
			key_time--;
	#endif
	
	#if (IBUS_LIMIT == 1)
		Ibus_Calculation();
	#endif
	
	Motor_Control(); 
	
	#if (dIPWM_MODE == 1)
		Buzzer_Fun();
	#endif
		
//	#if (POWER_LIMIT == 1)
//		PowerLimit_Fun();
//	#endif
//	
//	#if (POWER_CONTROL == 1)
//		PowerControl_Fun();
//	#endif
	
	
	#if (dUART_MODE == 1)
		UartCount += Timer1ms;
		if(UartCount >= PeriodTime10ms){
			UartFlag = 1;
			UartCount = 0;
		}
		Uart_Read_Handle();
	#endif

	IPDCount += Timer1ms;
	IPDCount &= 0xFFFF;

	Timer0Flag = 1;
	Timer0Count += Timer1ms;
	Timer0Count &= 0xFF;
	TF0 = 0;

	
}
//********************************************************************************
//								     INT1
//********************************************************************************
void External1_ISR (void) interrupt 2{
#if (IR_Control == 1)
	bit	ir_decode_data;
	if(FLAG.External1_TRIG==0)
		FLAG.External1_TRIG = 1;
	else{
		ir_read_counter = ir_read_counter_buf;
		ir_read_counter_buf = 0;
		
		if(FLAG.IR_Decode_Header==0){	// Decode head
			if(ir_read_counter>=ir_header_counter&&ir_read_counter<=200)
				FLAG.IR_Decode_Header = 1;
			else
				FLAG.External1_TRIG = 0;
		}
		else{
			if((ir_read_counter>5)&&(ir_read_counter<15))
				ir_decode_data = 0;
				
			else if((ir_read_counter>15)&&(ir_read_counter<25))
				ir_decode_data = 1;
			
			
			if(ir_counter<4){//byte
				ir_data[ir_counter] |= ir_decode_data;
				if(ir_data_shift_counter<7)	//bit
					ir_data[ir_counter] = (ir_data[ir_counter])<<1;
				ir_data_shift_counter++;
				
				if(ir_data_shift_counter==8){
					ir_data_shift_counter = 0;
					ir_counter+=1;
				}
			}
			else{
				FLAG.IR_Data_Decode_Finish = 1;
				EX1 = 0;
				ir_counter = 0;
				FLAG.External1_TRIG = 0;
				ir_read_counter_buf = 0;
				FLAG.IR_Decode_Header = 0;
			}			
		}
	}
#endif
}
//********************************************************************************
//								     Timer1
//********************************************************************************
void Timer1_ISR (void) interrupt 3{		//10mS
	TH1 = TIMER1_TH;
	TL1 = TIMER1_TL;

	if(Power_On == 1)
	{	
		IrDA_CMD = 0;
		Power_SW_cnt++;
		if(Power_SW_cnt >= 30)
		{
			Power_SW_cnt = 0;
			Power_On = 0;
		}
	}

	//#if (POWER_LIMIT == 1)
	//	Watt = Vbus_avg * Ibus_avg * dPOWER_GAIN;
	//#endif
	#if (POWER_CONTROL == 1) || (POWER_LIMIT == 1)
		if(abs(Vbus_avg - Vbus_avg_old) >= 50){ //28=1v
			if(vbus_high_sw == 0){
				vbus_high_sw = 1;
				Vbus_avg_old = Vbus_avg;
			}
		}
		else
			Vbus_avg_old = Vbus_avg;
	#endif

	#if (VSP_TRI == 1)
		Vsp_Fun();
	#endif
	
	#if (FaultLock_Protect == 1)
		FaultLock_Fun();
	#endif
	
	#if (Vbus_Protect == 1)
		Vbus_Protect_Fun(Vbus_avg);
	#endif
	
	#if (Temperature_Protect == 1)
		Temperature_Protect_Fun(Temperature_avg);
	#endif
	
	#if (POCP_Protect == 1)
		Phase_OCP_Protect_Fun();
	#endif
	
	Timer1Flag = 1;
	TF1 = 0;
}
//********************************************************************************
//								     UART
//********************************************************************************
#if (dUART_MODE == 1)
void Uart_ISR (void) interrupt 4{
	if(TI){
		Uart_Send_Buffer();
		TI = 0;
	}
	if(RI){
		Uart_Read_Buffer();
		RI = 0;
	}
}
#endif
//********************************************************************************
//								     Timer2
//********************************************************************************
void Timer2_ISR (void) interrupt 5{	//100uS
	TH2 = TIMER2_TH;//10mS @ 2MHz
	TL2 = TIMER2_TL;

	IrDA_Check();	

	#if (IR_Control == 1)
		if(FLAG.External1_TRIG==1){
			// if(ir_read_counter_buf<ir_header_counter+500)
			if(ir_read_counter_buf<1000)
				ir_read_counter_buf++;
			else{
				ir_counter = 0;
				ir_read_counter_buf = 0;
				FLAG.External1_TRIG = 0;
				FLAG.IR_Decode_Header = 0;
			}
		}
	#endif
	
	TF2 = 0;
}
//********************************************************************************
//								  OCP interrupt
//********************************************************************************
void OCP_ISR (void) interrupt 8{
	AOCP_Protect_Fun();
}
//********************************************************************************
//								 ADC interrupt
//********************************************************************************
void ADC_ISR (void) interrupt 9{
	#if (Vbus_Protect == 1)
		// Vbus_avg = LPF_Function(Adc_Channel(V_BUS_CH),Vbus_avg,16383);	//6.2us
		Vbus_avg = Adc_Channel(V_BUS_CH);	//3.2us
	#endif

	#if ((POWER_CONTROL == 1) || (POWER_LIMIT == 1))
		// Ibus_avg = LPF_Function(Adc_Channel(I_BUS_CH),Ibus_avg,16383);	//6.2us
		if(FLAG.Current_offset == 1) Ibus_avg = abs(Adc_Channel(I_BUS_CH) - OPA_Offset);
		else Ibus_avg = Adc_Channel(I_BUS_CH);
		
	#endif
		//Ibus_avg = Adc_Channel(2);
		
	#if (BEMF_TAILWIND_RES_FUNCTION == 1) || (BEMF_TAILWIND_DIODE_FUNCTION == 1)
		if((MotorState == M_TAILWIND)||(MotorState == M_IPD)){
			
			// BmfV = LPF_Function(Adc_Channel(BEMF_V_CH),BmfV,16383);	//6.2us
			// BmfW = LPF_Function(Adc_Channel(BEMF_W_CH),BmfW,16383);	//6.2us
			
			BmfV = Adc_Channel(BEMF_V_CH);
			BmfW = Adc_Channel(BEMF_W_CH);
		}
	#endif
	
	#if (VSP_TRI == 1)
		// Vsp_avg = LPF_Function(Adc_Channel(VSP_CH),Vsp_avg,32767);	//6.2us
		Vsp_avg = Adc_Channel(VSP_CH);
		Vsp_avg = 1023 - Vsp_avg;
	#endif
	
	#if (Temperature_Protect == 1)
		Temperature_avg = Adc_Channel(TEMPERATURE_CH);
	#endif
	
	// if(FLAG.Current_offset==0){
		// ia_values = LPF_Function(Adc_Channel(0),ia_values,10000);	//6.2us
		// ib_values = LPF_Function(Adc_Channel(1),ib_values,10000);	//6.2us
	// }
}
//********************************************************************************
//						    PWM_MIN_ISR interrupt
//********************************************************************************
/*void PmwMin_ISR (void) interrupt 10{
	//PwmFlag = 1;
}*/
//********************************************************************************
//						    PWM_MAX_ISR interrupt
//********************************************************************************
void PmwMax_ISR (void) interrupt 11{
	PwmFlag = 1;
}
//********************************************************************************
//						         IIC interrupt
//********************************************************************************
/*void IIC_ISR (void) interrupt 12{
	if((IICS & 0x08)){				// The data Transmit Interrupt Flag
		IICS &= (~0x08);
	}
	if((IICS & 0x10)){				// The data Receive Interrupt Flag
		IICS &= (~0x10);
	}

	if((IICS & 0x40)){				// The Stop condition Interrupt Flag
		IICS &= (~0x40);
	}
}*/
//********************************************************************************
//						      LowVoltage interrupt
//********************************************************************************
//void LowVoltage_ISR (void) interrupt 13{
	
//}
//********************************************************************************
//						      WatchDoag interrupt
//********************************************************************************
//void WatchDoag_ISR (void) interrupt 14{

//}
//********************************************************************************
//						         CAP interrupt
//********************************************************************************
void Cap_ISR (void) interrupt 15{
	#if (IR_Control == 1)
		IRDecode();
	#endif
}
